<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'invoice_number', 'invoice_date', 'company_name', 'customer_name', 'address',
        'contact', 'email', 'gst_number', 'subtotal', 'discount', 'balance_due','hsn_number', 'cgst', 'sgst',  'grand_total','gst_rate','gst_type'
    ];
    public function items()
    {
        return $this->hasMany(InvoiceItem::class);
    }
    
    public function customer()
{
    return $this->belongsTo(Customer::class);
}

}