<?php

namespace App\Http\Controllers;
use App\Models\Invoice;
use App\Models\Customer;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index(Request $request)
{
    $invoices = Invoice::with('customer')->get();

    // Total bills
    $totalBills = $invoices->count();

    // Month-wise bill count
    $monthWise = $invoices->groupBy(function($invoice) {
        return Carbon::parse($invoice->created_at)->format('Y-m');
    });

    // Client-wise bill count
    $clientWise = $invoices->groupBy('customer_id');

    // Date-wise bill count
    $dateWise = $invoices->groupBy(function($invoice) {
        return Carbon::parse($invoice->created_at)->format('Y-m-d');
    });

    return view('reports.index', compact('totalBills', 'monthWise', 'clientWise', 'dateWise'));
}
}