<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Report</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!-- Add Bootstrap for styling -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
  body {
    background-color: #f8f9fa;
    padding-top: 40px;
  }

  .container {
    max-width: 800px;
    margin: auto;
  }

  h2 {
    margin-bottom: 30px;
    text-align: center;
    color: #343a40;
  }

  .card {
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
  }

  ul {
    padding-left: 20px;
    margin-bottom: 0;
  }

  li {
    padding: 5px 0;
  }
  </style>
</head>

<body>

  <div class="container">
    <h2>📊 Report Summary</h2>

    <!-- Total Bills -->
    <div class="card p-3 mb-3">
      <strong>Total Bills:</strong> <?php echo e($totalBills); ?>

    </div>

    <!-- Month-wise -->
    <div class="card p-3 mb-3">
      <h4>📅 Month-wise Bills</h4>
      <ul>
        <?php $__currentLoopData = $monthWise; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $bills): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($month); ?>: <?php echo e($bills->count()); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>

    <!-- Client-wise -->
    <div class="card p-3 mb-3">
      <h4>👤 Client-wise Bills</h4>
      <ul>
        <?php $__currentLoopData = $clientWise; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clientId => $bills): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($bills->first()->customer->customer_name ?? 'Unknown'); ?>: <?php echo e($bills->count()); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>

    <!-- Date-wise -->
    <div class="card p-3 mb-3">
      <h4>📆 Date-wise Bills</h4>
      <ul>
        <?php $__currentLoopData = $dateWise; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $bills): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($date); ?>: <?php echo e($bills->count()); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>
  </div>

</body>

</html><?php /**PATH D:\xampp\htdocs\quotation-builder\resources\views\reports\index.blade.php ENDPATH**/ ?>