@extends('layouts.app')
@section('title', 'Create Quotation')




@if(session('success'))
<div class="alert alert-success">
  {{ session('success') }}
</div>
@endif
@error('hsn_number')
<span class="text-danger">{{ $message }}</span>
@enderror


@section('content')
<div class="container quotation-box">
  <div class="header">
    <h2>Quotation</h2>
    <img src="{{ URL('images/atjoin_logo.png') }}" alt="Company Logo">
  </div>

  <form action="{{ route('quotations.store') }}" method="POST">
    @csrf
    <div class="row quotation-details">
      <div class="col-md-6">
        <p><strong>Quotation No:</strong> {{ $quotation->quotationNumber ?? $quotationNumber }}</p>
      </div>
      <div class="col-md-6 text-end">

        <p><strong>Date:</strong> {{ $quotation->quotationDate }}</p>

      </div>
    </div>

    <div class="row company-details">
      <div class="col-md-6">
        <h5>Quotation From:</h5>
        <p>ATJOIN PVT.LTD<br>5th Floor, Luv-Kush Apt.<br>Seasons Business Center,<br>Opposite Kothari Hyundai
          Showroom,<br>Sanewadi, Aundh <br>Pune, Maharashtra 411007</p>
        <p><strong>Place of Supply:</strong> Pune</p>
      </div>

      <div class="col-md-6 " style="text-align: left; padding-left: 300px;">
        <h5>Quotation To:</h5>

        @php
        $selectedCustomer = App\Models\SelectCustomer::first();
        @endphp
        @if($selectedCustomer)

        <p><strong>Client Name:</strong> {{ $selectedCustomer->company_name }}</p>
        <p><strong>Customer Name:</strong> {{ $selectedCustomer->customer_name }}</p>
        <p><strong>Contact:</strong> {{ $selectedCustomer->contact }}</p>
        <p><strong>GST Number:</strong> {{ $selectedCustomer->gst_number }}</p>
        <p><strong>Email:</strong> {{ $selectedCustomer->email }}</p>
        <p><strong>Address:</strong> {{ $selectedCustomer->address }}</p>
        <p><strong>State:</strong> {{ $selectedCustomer->state }}</p>
        @endif

      </div>


      <table class="table table-bordered mt-3">
        <thead>
          <tr>
            <th>Sr No</th>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Amount</th>
            <th>Total Amount</th>
          </tr>
        </thead>
        <tbody>
          @if(isset($selectedRows) && count($selectedRows) > 0)
          @foreach($selectedRows as $row)
          <tr>
            <td><input type="text" name="sr_no[]" class="form-control" value="{{ $row['sr_no'] ?? '' }}" readonly>
            </td>
            <td><input type="text" name="description[]" class="form-control" value="{{ $row['description'] ?? '' }}"
                readonly></td>
            <td><input type="number" name="quantity[]" class="form-control" value="{{ $row['quantity'] ?? '' }}"
                readonly>
            </td>
            <td><input type="text" name="amount[]" class="form-control" value="{{ $row['amount'] ?? '' }}" readonly>
            </td>
            <td><input type="text" name="total_amount[]" class="form-control" value="{{ $row['total_amount'] ?? '' }}"
                readonly></td>
          </tr>
          @endforeach
          @else
          <tr>
            <td colspan="4" class="text-center">No data selected.</td>
          </tr>
          @endif

        </tbody>
      </table>

      <div class="text-end">
        <p><strong>Sub Total:</strong> ₹{{ number_format($subtotal, 2) }}</p>
        <p><strong>CGST :</strong> ₹{{ number_format($cgst, 2) }}</p>
        <p><strong>SGST :</strong> ₹{{  number_format($sgst, 2) }}</p>
        <p><strong>IGST :</strong> ₹{{  number_format($igst, 2) }}</p>
        <p><strong>Grand Total:</strong> ₹{{ number_format($grand_total, 2) }}</p>
      </div>

      @php
      $isMaharashtra = isset($selectedCustomer) && strtolower($selectedCustomer->state) === 'maharashtra';
      @endphp

      <table class="table table-bordered mb-3">
        <tr>
          <th>HSN/SAC</th>
          <th>Taxable Value</th>
          @if($isMaharashtra)
          <th colspan="2">CGST</th>
          <th colspan="2">SGST</th>
          <th colspan="2" class="text-muted">IGST</th>
          @else
          <th colspan="2" class="text-muted">CGST </th>
          <th colspan="2" class="text-muted">SGST </th>
          <th colspan="2">IGST</th>
          @endif
          <th>Total Tax Amount</th>
        </tr>

        <tr>
          <th></th>
          <th></th>
          @if($isMaharashtra)
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          @else
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          @endif
          <th></th>
        </tr>

        <tr>
          <td>
            <input type="text" name="hsn_number" placeholder="Enter HSN Number" class="form-control text-center"
              required>
          </td>
          <td>{{ number_format($gst_rate, 2) }}%</td>

          @if($isMaharashtra)
          <td>{{ $gst_rate / 2 }}%</td>
          <td>₹{{ number_format($cgst, 2) }}</td>
          <td>{{ $gst_rate / 2 }}%</td>
          <td>₹{{ number_format($sgst, 2) }}</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          @else
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td>{{ $gst_rate }}%</td>
          <td>₹{{ number_format($igst, 2) }}</td>
          @endif

          <td>
            @if($isMaharashtra)
            ₹{{ number_format($cgst + $sgst, 2) }}
            @else
            ₹{{ number_format($igst, 2) }}
            @endif
          </td>
        </tr>

        <tr>
          <td><strong>Total:</strong></td>
          <td><strong>{{ number_format($gst_rate, 2) }}%</strong></td>

          @if($isMaharashtra)
          <td><strong>{{ $gst_rate / 2 }}%</strong></td>
          <td><strong>₹{{ number_format($cgst, 2) }}</strong></td>
          <td><strong>{{ $gst_rate / 2 }}%</strong></td>
          <td><strong>₹{{ number_format($sgst, 2) }}</strong></td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          @else
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td><strong>{{ $gst_rate }}%</strong></td>
          <td><strong>₹{{ number_format($igst, 2) }}</strong></td>
          @endif

          <td>
            <strong>
              @if($isMaharashtra)
              ₹{{ number_format($cgst + $sgst, 2) }}
              @else
              ₹{{ number_format($igst, 2) }}
              @endif
            </strong>
          </td>
        </tr>
      </table>


      <div class="w-50">
        <button type="submit" class="btn btn-primary">Save</button>
      </div>

  </form>
</div>

@endsection