<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Quotation PDF</title>
  <style>
  @font-face {
    font-family: 'DejaVu Sans';
    font-style: normal;
    font-weight: normal;
    src: url("{{ public_path('fonts/DejaVuSans.ttf') }}") format('truetype');
    <link rel="stylesheet"href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  }

  body {
    font-family: 'DejaVu Sans', Arial, sans-serif;
    font-size: 14px;
    max-width: 100%;
    margin: 0;
    padding: 0;
  }

  .quotation-box {
    width: 90%;
    margin: 20px auto;
    padding: 20px;
    border: 1px solid #ddd;
    background: #fff;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
    border-radius: 10px;
  }

  /* Header */
  .header {
    text-align: center;
    border-bottom: 2px solid #ddd;
    padding-bottom: 15px;
    margin-bottom: 20px;
  }

  .header img {
    max-width: 120px;
    margin-bottom: 10px;
  }

  .header h2 {
    margin: 5px 0;
    font-size: 22px;
    text-transform: uppercase;
  }

  /* Quotation Details */
  .quotation-details {
    display: flex;
    justify-content: space-between;
    border-bottom: 1px solid #ddd;
    padding-bottom: 10px;
    margin-bottom: 20px;
  }

  .quotation-details p {
    margin: 5px 0;
    font-size: 14px;
  }

  /* Customer and Company Details */
  .details-container {
    display: flex;
    justify-content: space-between;
    margin-bottom: 20px;
  }

  .company-details,
  .customer-details {
    width: 48%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 5px;
    background: #f9f9f9;
  }

  .details-container h5 {
    margin-bottom: 8px;
    font-size: 14px;
    text-decoration: underline;
  }

  .details-container p {
    margin: 3px 0;
    font-size: 13px;
  }

  /* Table */
  .table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 15px;
  }

  .table th,
  .table td {
    border: 1px solid #ddd;
    padding: 8px;
    text-align: center;
    font-size: 13px;
  }

  .table th {
    background: #f2f2f2;
    font-weight: bold;
  }

  /* Summary */
  .summary {
    margin-top: 15px;
    text-align: right;
  }

  .summary p {
    font-size: 14px;
    font-weight: bold;
    margin: 3px 0;
  }

  /* Footer */
  .footer {
    margin-top: 20px;
    padding-top: 10px;
    border-top: 1px solid #ddd;
  }

  .footer h5 {
    margin-bottom: 8px;
    font-size: 14px;
    text-decoration: underline;
  }

  .footer p,
  .footer ul {
    font-size: 13px;
    margin: 5px 0;
  }

  .btn {
    display: inline-block;
    padding: 10px 20px;
    font-size: 16px;
    font-weight: bold;
    text-align: center;
    text-decoration: none;
    color: white;
    background-color: #007bff;
    border: none;
    border-radius: 5px;
    transition: background 0.3s ease;
  }

  .btn:hover {
    background-color: #0056b3;
  }
  </style>
</head>

<body>
  <div class="quotation-box">
    <!-- Header -->
    <div class="header">
      <img src="{{ URL('images/atjoin_logo.png') }}" alt="Company Logo">
      <h2>Quotation</h2>
    </div>

    <!-- Quotation Details -->
    <div class="quotation-details">
      <p><strong>Quotation No:</strong> {{ $quotation->quotation_number }}</p>
      <p><strong>Date:</strong> {{ $quotation->quotation_date }}</p>
    </div>

    <!-- Company & Customer Details -->
    <div class="details-container">
      <div class="company-details">
        <h5>Quotation By:</h5>
        <p>ATJOIN PVT. LTD<br>5th Floor, Luv-Kush Apt.<br>Seasons Business Center,<br>Opp. Kothari Hyundai
          Showroom,<br>Sanewadi, Aundh, Pune, Maharashtra 411007</p>
        <p><strong>GST No:</strong>27AAWCA2027J1ZE </p>
        <p><strong>Place of Supply:</strong> Pune</p>
      </div>

      <div class="customer-details">
        <h5>Quotation To:</h5>
        @php
        $selectedCustomer = App\Models\SelectCustomer::first();
        @endphp
        @if($selectedCustomer)
        <p><strong>Company Name:</strong> {{ $selectedCustomer->company_name }}</p>
        <p><strong>Customer Name:</strong> {{ $selectedCustomer->customer_name }}</p>
        <p><strong>Contact:</strong> {{ $selectedCustomer->contact }}</p>
        <p><strong>GST Number:</strong> {{ $selectedCustomer->gst_number }}</p>
        <p><strong>Email:</strong> {{ $selectedCustomer->email }}</p>
        <p><strong>Address:</strong> {{ $selectedCustomer->address }}</p>
        <p><strong>City:</strong> {{ $selectedCustomer->city }}</p>
        @endif
      </div>
    </div>

    <!-- Items Table -->
    <table class="table">
      <thead>
        <tr>
          <th>Item Description</th>
          <th>HSN</th>
          <th>Qty</th>
          <th>Amount</th>
          <th>Total Amount</th>
        </tr>
      </thead>
      <tbody>
        @foreach($quotation->items as $item)
        <tr>
          <td>{{ $item->description }}</td>
          <td>{{$quotation->hsn_number}}</td>
          <td>{{ $item->quantity }}</td>
          <td>₹{{ number_format($item->amount, 2) }}</td>
          <td>₹{{ number_format($item->total_amount, 2) }}</td>
        </tr>
        @endforeach


        <tr>
          <td colspan="5" style="text-align: right;"><strong>CGST ₹{{ number_format($quotation->cgst, 2) }}</strong>
          </td>

        </tr>
        <tr>
          <td colspan="5" style="text-align: right;"><strong>SGST ₹{{ number_format($quotation->sgst, 2) }}</strong>
          </td>

        </tr>
        <tr>
          <td colspan="5" style="text-align: right;"><strong>Total
              ₹{{ number_format($quotation->grand_total, 2) }}</strong></td>

        </tr>
      </tbody>
    </table>


    <table class="summary-table" border="1" cellpadding="5" cellspacing="0"
      style="width:100%; border-collapse: collapse;">
      <tr>
        <th>HSN/SAC</th>
        <th>Taxable Value</th>
        <th colspan="2">CGST</th>
        <th colspan="2">SGST</th>
        <th>Total Tax Amount</th>
      </tr>
      <tr>

        <!-- Manually Inserted -->
        <th></th>
        <th></th>
        <th>Rate (%)</th>
        <th>Amount (₹)</th>
        <th>Rate (%)</th>
        <th>Amount (₹)</th>
        <th></th>
      </tr>
      <tr>
        <td>{{$quotation->hsn_number}}</td>
        <!-- Manually Inserted -->
        <td>₹{{ number_format($quotation->gst_rate, 2) }}</td>
        <td>{{ $quotation->gst_rate / 2 }}%</td>
        <td>₹{{ number_format($quotation->cgst, 2) }}</td>
        <td>{{ $quotation->gst_rate / 2 }}%</td>
        <td>₹{{ number_format($quotation->sgst, 2) }}</td>
        <td>₹{{ number_format($quotation->cgst + $quotation->sgst, 2) }}</td>
      </tr>
      <tr>
        <td><strong>Total:</strong></td>
        <td><strong>₹{{ number_format($quotation->gst_rate, 2) }}</strong></td>
        <td><strong>{{ $quotation->gst_rate / 2 }}%</strong></td>
        <td><strong>₹{{ number_format($quotation->cgst, 2) }}</strong></td>
        <td><strong>{{ $quotation->gst_rate / 2 }}%</strong></td>
        <td><strong>₹{{ number_format($quotation->sgst, 2) }}</strong></td>
        <td><strong>₹{{ number_format($quotation->cgst + $quotation->sgst, 2) }}</strong></td>
      </tr>
    </table>




    <!-- Footer -->
    <div class="footer">
      <h5>Terms and Conditions</h5>
      <ul>
        <li>Payment due within 15 days.</li>
        <li>Overdue interest at 18% will be charged on delayed payments.</li>
      </ul>

      <h5>Additional Notes</h5>
      <p>This quotation is valid for 30 days from the date of issue.</p>
      <p>This quotation is {{ $quotation->gst_type }} GST.</p>
    </div>
    <a href="{{ route('pdf.quotationpdf', $quotation->id) }}" type="submit" class="btn">Generate Pdf</a>


  </div>
</body>

</html>