<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Invoice</title>

  <style>
  @font-face {
    font-family: 'DejaVu Sans';
    font-style: normal;
    font-weight: normal;
    src: url("{{ public_path('fonts/DejaVuSans.ttf') }}") format('truetype');
  }

  body {
    font-family: 'DejaVu Sans', sans-serif;
    font-size: 12px;
    color: #333;
    margin: 0;
    padding: 0;
  }

  .container {
    padding: 30px;
  }

  .logo {
    width: 150px;
    margin-bottom: 10px;
  }

  .invoice-title {
    font-size: 16px;
    font-weight: bold;
    text-align: center;
    margin-bottom: 20px;
    border-bottom: 2px solid #333;
    padding-bottom: 10px;
  }

  .section-title {
    font-weight: bold;
    margin-bottom: 8px;
  }

  .table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
  }

  .table th {
    border: 1px solid #333;
    padding: 10px;
    text-align: left;
  }

  .table th {
    background-color: #f5f5f5;
  }

  .info-table td {
    border: none;
    padding: 0 10px 10px 0;
  }

  .totals {
    margin-top: 20px;
    float: right;
    width: 50%;
  }

  .totals h4 {
    margin: 5px 0;
  }

  .clearfix::after {
    content: "";
    display: table;
    clear: both;
  }

  .footer {
    margin-top: 50px;
    font-size: 12px;
    text-align: center;
    color: #999;
  }
  </style>
</head>

<body>
  <div class="container">
    <table style="width: 100%; margin-bottom: 20px;">
      <tr>
        <td style="width: 50%;">
          <img src="{{ public_path('images/atjoin_logo.png') }}" class="logo">
        </td>
        <td style="text-align: right;">
          <h2 class="invoice-title">INVOICE</h2>
        </td>
      </tr>
    </table>

    <table class="info-table">
      <tr>
        <td style="width: 50%;">
          <div class="section-title">Invoice By</div>
          <strong>ATJOIN PVT. LTD</strong><br>
          5th Floor, Luv-Kush Apt., Seasons Business Center,<br>
          Opp. Kothari Hyundai Showroom, Sanewadi, Aundh,<br>
          Pune, Maharashtra 411007<br>
          <strong>Place of Supply:</strong> Pune<br>
          <strong>GST No:</strong> 27AAWCA2027J1ZE
        </td>
        <td>
          <div class="section-title">Bill To</div>
          <strong>Company Name:</strong> {{ $invoice->company_name }}<br>
          <strong>Customer Name:</strong> {{ $invoice->customer_name }}<br>
          <strong>Address:</strong> {{ $invoice->address }}<br>
          <strong>Contact:</strong> {{ $invoice->contact }}<br>
          <strong>Email:</strong> {{ $invoice->email }}<br>
          <strong>GST NO:</strong> {{ $invoice->gst_number }}
        </td>
      </tr>
    </table>

    <div style="margin-top: 20px;">
      <strong>Invoice No:</strong> {{ $invoice->invoice_number }}<br>
      <strong>Invoice Date:</strong> {{ $invoice->invoice_date }}
    </div>

    <!-- Items Table -->
    <table class="table">
      <thead>
        <tr>
          <th>Description</th>
          <th>Quantity</th>
          <th>Rate</th>
          <th>Total Amount</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($invoice->items as $item)
        <tr>
          <td style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">
            {{ $item->description }}</td>
          <td style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">{{ $item->quantity }}
          </td>
          <td style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">&#8377;
            {{ number_format($item->amount, 2) }}</td>
          <td style="border-left: 1px solid black; border-right: 1px solid black;  padding: 10px;">
            &#8377;
            {{ number_format($item->total_amount, 2) }}</td>
        </tr>
        @endforeach
      </tbody>
    </table>

    <!-- Totals -->
    <table style="width: 100%;  border: 1px solid black; padding: 10px; text-align: right;">
      <tr>
        <td style="width: 50%;"></td>
        <td style="text-align: right;">
          <strong>Subtotal:</strong> &#8377; {{ number_format($invoice->subtotal, 2) }}<br>
          <strong>Discount:</strong> &#8377; {{ number_format($invoice->discount, 2) }}<br>
          <strong>Balance Due:</strong> &#8377; {{ number_format($invoice->balance_due, 2) }}
        </td>
      </tr>
    </table>


  </div>
</body>

</html>