<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SelectCustomer extends Model
{
    use HasFactory;

    protected $table = 'selected_customer';
    protected $fillable = [
        'customer_id',
        'company_name',
        'customer_name',
        'contact',
        'gst_number',
        'email',
        'address',
        'city'
    ];

    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id');
    }
}